unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  ExtCtrls, ComCtrls;

type
  TForm1 = class(TForm)
    StatusBar1: TStatusBar;
    Timer1: TTimer;
    procedure StatusBar1DrawPanel(StatusBar: TStatusBar;
      Panel: TStatusPanel; const Rect: TRect);
    procedure Timer1Timer(Sender: TObject);
  private
    { Private declarations }
  public
    { Public declarations }
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

procedure TForm1.StatusBar1DrawPanel(StatusBar: TStatusBar;
  Panel: TStatusPanel; const Rect: TRect);
var
  Status : Boolean;
  Texto : String;
begin
  Status := False;
  with StatusBar1 do begin
    if Panel = Panels[1] then begin
      Status := (GetKeyState(VK_NUMLOCK) and 1) <> 0;
      Texto := 'Num';
    end
    else if Panel = Panels[2] then begin
      Status := (GetKeyState(VK_CAPITAL) and 1) <> 0;
      Texto := 'Caps';
    end
    else if Panel = Panels[3] then begin
      Status := (GetKeyState(VK_SCROLL) and 1) <> 0;
      Texto := 'Scrl';
    end;
    if Status then begin
      Canvas.Brush.Color := clLime;
      Canvas.FillRect(Rect);
    end;
    SetTextAlign(Canvas.Handle,TA_CENTER or TA_TOP);
    Canvas.TextOut((Rect.Left+Rect.Right) div 2, Rect.Top, Texto);
  end;
end;

procedure TForm1.Timer1Timer(Sender: TObject);
begin
  Statusbar1.Invalidate;
end;

end.
